//
//  GSFontMaster.h
//  Glyphs
//
//  Created by Georg Seifert on 6.9.07.
//  Copyright 2007 schriftgestaltung.de. All rights reserved.
//

#import <Cocoa/Cocoa.h>

@class GSFont;
@class GSLayer;
#ifndef GLYPHS_VIEWER
@class GSGuideLine;
@class GSCustomProperty;
#endif
@class GSAlignmentZone;

/** The class defining the fontmaster object */
#ifndef GLYPHS_VIEWER
@interface GSFontMaster : NSObject <NSCoding, NSCopying> {
#else
@interface GSFontMaster : NSObject {
#endif
	//NSInteger _index;
	GSFont				*__unsafe_unretained _font;
	CGFloat				_xHeight;
	CGFloat				_descender;
	CGFloat				_ascender;
	CGFloat				_capHeight;
	CGFloat				_italicAngle;
	NSMutableArray		*_alignmentZones;
#ifndef GLYPHS_VIEWER
	NSMutableArray		*_verticalStems, *_horizontalStems;
	NSMutableDictionary	*_userData;
#endif
	NSString			*_weight;
	NSString			*_width;
	NSString			*_custom;
	NSString			*_id;
	CGFloat				_weightValue, _widthValue, _customValue;
#ifndef GLYPHS_VIEWER
	NSMutableArray		*_guideLines;
#endif
	NSMutableDictionary	*_changeCount;
	NSMutableIndexSet	*_alignmentZoneCache;
	NSMutableArray *	_customParameters;
	NSMutableArray *	_metricsList;
}
@property(unsafe_unretained, nonatomic) GSFont* font;
/** @name Properties */

/** the name of the FontMaster
 e.g; "Regular", "Condensed", ...
 */
@property(unsafe_unretained, readonly, nonatomic) NSString* name;

/** The width tag

 Something like Condensed or Extended
 */
@property(copy, nonatomic) NSString* width;

/** The weight tag
 
 Something like Light or Regular
 */
@property(copy, nonatomic) NSString* weight;

/** A custom tag */
@property(copy, nonatomic) NSString* custom;

/** The weight value

 The weight value defines the place of the Fontmaster in the "design space"
 */
@property(assign, nonatomic) CGFloat weightValue;

/** The width value

 The width value defines the place of the Fontmaster in the "design space"
 */
@property(assign, nonatomic) CGFloat widthValue;

/** The custom value
 
 The custom value defines the place of the Fontmaster in the "design space"
 */
@property(assign, nonatomic) CGFloat customValue;

/// The id
@property(copy, nonatomic) NSString* id;

/// The descender.
@property (nonatomic) CGFloat descender;

/// The ascender.
@property (nonatomic) CGFloat ascender;

/// The capHeight.
@property (nonatomic) CGFloat capHeight;
/// The xHeight.
@property (nonatomic) CGFloat xHeight;
/// The Italic angle
@property (nonatomic) CGFloat italicAngle;
/// list of vertical stems
@property (strong, nonatomic) NSMutableArray * verticalStems;
/// list of horizontal stems
@property (strong, nonatomic) NSMutableArray * horizontalStems;
/// list of alignment zones
@property (strong, nonatomic) NSArray * alignmentZones;
/// list of guidelines
@property (strong, nonatomic) NSArray * guideLines;
/** Place for plugins to store data .

 Here it is possible to store something. Please use a unique key.
 The objects should be able to serialize to a plist. if they are not they should return all infos to store to save as string in description.
 */
@property(strong, nonatomic) NSMutableDictionary * userData;
@property(strong, nonatomic) NSMutableArray *customParameters;

/** @name Initializing an Font Master */

/// Inits with a Dict loaded from pList.
- (id) initWithFontMasterDict:(NSDictionary *) FontMasterDict;
#ifndef GLYPHS_VIEWER
/// Returnes the Font Master to save it in plist
- (NSDictionary*) fontMasterDict;

- (BOOL) saveToFile:(FILE*) File error:(NSError**) error ;

/** @name Guidelines */

/** Number of Guide Lines
 
 @return Number of Guide Lines 
 */
- (NSUInteger) guideLineCount ;

/** Returns the Guide Line located at Index.
 @param Index An index within the bounds of the array.
 @return The Guide Line located at index.
 */
- (id) guideLineAtIndex:(NSUInteger)theIndex ;
//- (void) getGuideLines:(id *)objsPtr range:(NSRange)range ;
- (void) addGuideLine:(GSGuideLine*)GuideLine ;
- (void) removeGuideLine:(GSGuideLine*) GuideLine ;
- (void) insertGuideLine:(GSGuideLine*)GuideLine atIndex:(NSUInteger)theIndex ;
- (void) removeGuideLineAtIndex:(NSUInteger)theIndex ;
#endif
/** @name Alignment Zones */
/** Number of alignment zones
 
 @return Number of alignment zones 
 */
- (NSUInteger) countOfAlignmentZones ;

/** Returns the alignment zone located at Index.
 @param Index An index within the bounds of the array.
 @return The object located at index.
 */
- (GSAlignmentZone*) alignmentZoneAtIndex:(NSUInteger)Index ;
/** adds an alignment zone
 @param AlignmentZone a GSAlignmentZone object
 */
#ifndef GLYPHS_VIEWER
- (void) addAlignmentZone: (GSAlignmentZone*) AlignmentZone ;
- (void) addAlignmentZones: (NSArray*) AlignmentZones ;
- (void) removeAlignmentZone: (GSAlignmentZone*) AlignmentZone ;
- (void) removeAlignmentZones: (NSArray*) AlignmentZones ;
- (void) removeAlignmentZoneAtIndex:(NSUInteger)theIndex ;
- (void) removeAlignmentZoneAtIndexes:(NSIndexSet*)theIndexes ;
- (void) sortAlignmentZones;
- (NSArray*) blueValues;
- (NSArray*) otherBlues;
#endif
- (BOOL) isInAlignmentZone: (NSInteger) Height ;
- (BOOL) isOnVerticalMetrics: (NSInteger) Height layer:(GSLayer*) Layer ;
#ifndef GLYPHS_VIEWER
///////  customParameters  ///////
- (NSArray *) customParameters;
- (NSUInteger) countOfCustomParameters;
- (GSCustomProperty*) objectInCustomParametersAtIndex:(NSUInteger)theIndex;
#endif
- (id) customColorValueForKey:(NSString*) Key ;
- (id) customValueForKey:(NSString*) Key ;
- (GSCustomProperty*) customPropertyForKey:(NSString*) Key ;
#ifndef GLYPHS_VIEWER
- (void) addCustomParameter:(GSCustomProperty *)Property ;
- (void) removeCustomParameter:(GSCustomProperty *)Property ;
- (void) setCustomParameter:(id)value forKey:(NSString*)key;
- (void) removeObjectFromCustomParametersForKey:(NSString*) Key;
- (void) insertObject:(GSCustomProperty *)aCustomProperty inCustomParametersAtIndex:(NSUInteger)idx;
- (void) removeObjectFromCustomParametersAtIndex:(NSUInteger)idx;
- (void) replaceObjectInCustomParametersAtIndex:(NSUInteger)idx withObject:(GSCustomProperty *)aCustomProperty;

/** @name Other Methods */
/** Scales the Font Master
  Scales the vertical metrics, alignment zones and guide lines
 @param Scale the scale factor (1 means no scaling.)
 */
- (void) scaleBy:(CGFloat) Scale ;

- (void) fixAlignmentZone ;
#endif
@end
